#####################################################
###########     Roteiro aula prática 5     ##########
###########     ANÁLISE DISCRIMINANTE       #########
#####################################################

#Instalando o pacote necessário
install.packages("MASS")
#Carregando o paconte na memória do RStudio
library(MASS)

#----------------------------------------------------
#Estimando a função discriminante linear
d.l <- lda (pop ~ x1 + x2 + x3 + x4, data=fal)
#Obtendo os resultados
print(d.l)
#----------------------------------------------------
#Fazendo predições
## The tidyverse is an opinionated collection of R 
## packages designed for data science
install.packages("tidyverse") 
library("tidyverse")
## Package caret streamline the process for creating 
## predictive models.
install.packages("caret")
library(caret)

p.l <- d.l %>% predict(fal)
# dis - nome do objeto que possui o modelo da função 
## discriminante estimada;
# predict - função
# fal - nome do banco de dados
# predicitions - salvar as predições o objeto predictions
names(p.l)
# [1] "class"     "posterior" "x" 
# Analsando os objetos
# class - indica em qual grupo cada objeto foi classificado;
# posterior - probabilidade a posteriori estimado pelo modelo;
# x - valor da função discriminante estimada
## Classificação dos 18 primeiros elementos:
head(p.l$class, 18)
## Probabilidade de pertencer à pop 0 e 1
head(p.l$posterior,18)
## Valor do escore estimado pela função discriminante
head(p.l$x,18)

#----------------------------------------------------
#Análise da qualidade do modelo (por resubistituição)
# Compara os grupos preditos com os verdadeiros grupos 
l<-mean(p.l$class == fal$pop)

#-------------------------------------------------------
# Classificação dos elementos por população
## Número de elementos classificados
table(fal$pop, p.l$class, dnn=c("Real","Classificação"))
## Classificação percentual
table(fal$pop, p.l$class, dnn=c("Real","Classificação")) %>%
  prop.table(1) %>% round(3)
## Equival a calcule a tabela de acertos, então, calcule a probabilidade
## e por fim, arredonde a 3 casas decimais.
#Observe que a rotina acima é equivalente a 
round(prop.table((table(fal$pop, p.l$class, dnn=c("Real","Classificação"))),1),3)
## Assim, o pepe (%>%) permite um comando mais simples 

#-----------------------------------------------------
#Matriz de confusão
predito <- p.l$class
observado <- as.factor(fal$pop)
confusionMatrix(predito, observado)
#ou, salvando no objeto c.l
c.l<-confusionMatrix(predito, observado)
#como salvamos no objetio c.l, precisamos da função print
print(c.l)
#-----------------------------------------------------
#-----------------------------------------------------
# Função discriminante quadrática

# Calculando a função discriminane quadrática
d.q <- qda (pop ~ x1 + x2 + x3 + x4, data=fal)

# Exibindo os resultados
print(d.q)

#----------------------------------------------------
#Análise da qualidade do modelo (por resubistituição)
#Obtendo os valores preditos 
p.q <- d.q %>% predict(fal)

#Acerto global do modelo
q<-mean(p.q$class == fal$pop)

table(fal$pop, p.q$class, dnn=c("Real","Classificação")) %>%
  prop.table(1) %>% round(3)

#Matriz de confusão
predito.q <- p.q$class
observado <- as.factor(fal$pop)
c.q<-confusionMatrix(predito.q, observado)

